﻿using System.Collections.Concurrent;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;

public class StationConfigurationRepository
{
    private const string CONNECT_STRING_NAME = "RegistryConnectionString";
    private const string USP_GET_STATION_CONFIGURATIONS = "[EFR].[usp_GetStationConfigurations]";

    internal ConcurrentDictionary<string, StationConfiguration> GetConfigurationMap()
    {
        var results = new ConcurrentDictionary<string, StationConfiguration>();

        var connectionString = ConfigurationManager.ConnectionStrings[CONNECT_STRING_NAME].ConnectionString;

        using (SqlConnection connection = new SqlConnection(connectionString))
        using (SqlCommand selectCommand = new SqlCommand(USP_GET_STATION_CONFIGURATIONS, connection))
        {
            selectCommand.CommandType = CommandType.StoredProcedure;

            connection.Open();

            using (SqlDataReader reader = selectCommand.ExecuteReader())
            {
                while (reader.Read())
                {
                    var dr = reader;
                    var station = dr.GetString((int)StationConfigurationOrdinal.StationName);
                    results.TryAdd(station, new StationConfiguration(dr));
                }
            }
        }

        return results;
    }

}

